/*
 * Decompiled with CFR 0.152.
 */
package noobanidus.mods.lootr.common.command;

import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import net.minecraft.class_1799;
import net.minecraft.class_1923;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2371;
import net.minecraft.class_2561;
import net.minecraft.class_2586;
import net.minecraft.class_2624;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3218;
import net.minecraft.class_3230;
import net.minecraft.server.MinecraftServer;
import noobanidus.mods.lootr.common.api.LootrTags;
import noobanidus.mods.lootr.common.api.registry.LootrRegistry;
import noobanidus.mods.lootr.common.block.entity.LootrInventoryBlockEntity;
import noobanidus.mods.lootr.common.command.CommandLootr;
import noobanidus.mods.lootr.common.mixin.accessor.AccessorMixinBaseContainerBlockEntity;

public final class CustomConvertJob {
    private static final ThreadFactory THREAD_FACTORY = new ThreadFactoryBuilder().setDaemon(true).setNameFormat("lootr-convert-%d").build();
    private static Thread convertThread;
    private static final int TICKET_LEVEL = 2;
    private static final int batchSize = 2;

    public static void start(MinecraftServer server, class_3218 level, List<class_1923> positions, class_2168 src) {
        if (convertThread != null && convertThread.isAlive()) {
            src.method_9213((class_2561)class_2561.method_43470((String)"A conversion job is already running."));
            return;
        }
        AtomicBoolean running = new AtomicBoolean(true);
        AtomicInteger processed = new AtomicInteger();
        AtomicInteger converted = new AtomicInteger();
        AtomicInteger skipped = new AtomicInteger();
        AtomicInteger convertedBlockEntities = new AtomicInteger();
        convertThread = THREAD_FACTORY.newThread(() -> {
            try {
                for (int i = 0; i < positions.size() && running.get(); i += 2) {
                    int from = i;
                    int to = Math.min(i + 2, positions.size());
                    CompletableFuture batchDone = new CompletableFuture();
                    server.execute(() -> {
                        try {
                            for (int j = from; j < to; ++j) {
                                class_1923 cp = (class_1923)positions.get(j);
                                int convertedCount = CustomConvertJob.processOneChunkOnServerThread(level, cp, src);
                                processed.incrementAndGet();
                                if (convertedCount > 0) {
                                    converted.incrementAndGet();
                                    convertedBlockEntities.addAndGet(convertedCount);
                                    continue;
                                }
                                skipped.incrementAndGet();
                            }
                            if (processed.get() % 50 == 0) {
                                src.method_9226(() -> class_2561.method_43470((String)("Progress: " + processed.get() + "/" + positions.size() + " converted=" + converted.get() + " chunks, skipped=" + skipped.get() + " empty chunks, converted a total of " + convertedBlockEntities.get() + " block entities to custom inventories.")), true);
                            }
                            batchDone.complete(null);
                        }
                        catch (Throwable t) {
                            batchDone.completeExceptionally(t);
                        }
                    });
                    batchDone.join();
                }
                server.execute(() -> src.method_9226(() -> class_2561.method_43470((String)("Conversion complete. processed=" + processed.get() + " converted=" + converted.get() + " skipped=" + skipped.get())), true));
            }
            catch (Throwable t) {
                server.execute(() -> src.method_9213((class_2561)class_2561.method_43470((String)("Conversion failed: " + String.valueOf(t)))));
            }
        });
        convertThread.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static int processOneChunkOnServerThread(class_3218 level, class_1923 pos, class_2168 src) {
        if (level == null) {
            src.method_9213((class_2561)class_2561.method_43470((String)"Level not found."));
            return 0;
        }
        level.method_14178().method_66009(class_3230.field_14031, pos, 0);
        try {
            class_2818 chunk = level.method_8497(pos.field_9181, pos.field_9180);
            int changed = 0;
            for (class_2338 bePos : chunk.method_12021()) {
                class_2624 container;
                class_2586 be = chunk.method_12201(bePos, class_2818.class_2819.field_12860);
                if (be == null || LootrTags.BlockEntity.isTagged(be, LootrTags.BlockEntity.CUSTOM_INELIGIBLE) || !be.method_11010().method_26164(LootrTags.Blocks.CUSTOM_ELIGIBLE) || !(be instanceof class_2624) || (container = (class_2624)be).method_5442()) continue;
                changed += CustomConvertJob.convertAt(level, bePos, be, src);
            }
            int n = changed;
            return n;
        }
        finally {
            level.method_14178().method_66010(class_3230.field_14031, pos, 0);
        }
    }

    private static int convertAt(class_3218 level, class_2338 pos, class_2586 blockEntity, class_2168 src) {
        class_2680 state = blockEntity.method_11010();
        class_2371<class_1799> reference = ((AccessorMixinBaseContainerBlockEntity)blockEntity).invokeGetItems();
        class_2680 newState = CommandLootr.updateBlockState(state, LootrRegistry.getInventoryBlock().method_9564());
        class_2371<class_1799> custom = CommandLootr.copyItemList(reference);
        level.method_8544(pos);
        level.method_8501(pos, newState);
        class_2586 te = level.method_8321(pos);
        if (!(te instanceof LootrInventoryBlockEntity)) {
            src.method_9213((class_2561)class_2561.method_43470((String)("Unable to convert chest at '" + String.valueOf(pos) + "', BlockState is not a Lootr Inventory block.")));
            return 0;
        }
        LootrInventoryBlockEntity inventory = (LootrInventoryBlockEntity)te;
        inventory.setCustomInventory(custom);
        inventory.method_5431();
        return 1;
    }
}

